#ifndef RANGE_DATA_DRAW_WIDGET_H
#define RANGE_DATA_DRAW_WIDGET_H

/*!
  \file
  \brief レンジセンサデータの描画ウィジット

  \author Satofumi KAMIMURA

  $Id: RangeDataDrawWidget.h 260 2008-10-08 10:39:09Z satofumi $
*/

#include "GridTypes.h"
#include <QWidget>


class RangeDataDrawWidget : public QWidget
{
  Q_OBJECT;

  RangeDataDrawWidget(const RangeDataDrawWidget& rhs);
  RangeDataDrawWidget& operator = (const RangeDataDrawWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

protected:
  void paintEvent(QPaintEvent* event);

private slots:
  // !!!

public:
  RangeDataDrawWidget(QWidget* parent = 0);
  ~RangeDataDrawWidget(void);

  // !!! 描画に使う予定のバッファを渡せるようにする
  // !!! UrgCtrl() で取得したデータのコピーをなくすことができる

  void setData(const std::vector<qrk::Grid<int> >& points);

  double zoom(void);
  void setZoom(double zoom);

public slots:
  void redraw(void);
};

#endif /* !RANGE_DATA_DRAW_WIDGET_H */
