/*!
  \file
  \brief レンジセンサデータの描画ウィジット

  \author Satofumi KAMIMURA

  $Id: RangeDataDrawWidget.cpp 260 2008-10-08 10:39:09Z satofumi $
*/

#include "RangeDataDrawWidget.h"
#include <QPainter>
#include <vector>

using namespace qrk;


struct RangeDataDrawWidget::pImpl
{
  RangeDataDrawWidget* parent_;
  std::vector<Grid<int> > data_points_;
  double zoom_;


  pImpl(RangeDataDrawWidget* parent) : parent_(parent), zoom_(1.0)
  {
  }


  void initializeForm(void)
  {
    // !!!
  }


  void redraw(void)
  {
    QPainter painter(parent_);

    QRect widget_rect = parent_->rect();
    widget_rect.setWidth(widget_rect.width() - 1);
    widget_rect.setHeight(widget_rect.height() - 1);

    // 背景は白色
    painter.fillRect(widget_rect, QBrush(Qt::white));

    // レーザ線を青色
    painter.setPen(QPen(Qt::blue));

    QPoint center(widget_rect.width() / 2, widget_rect.height() / 2);
    for (std::vector<Grid<int> >::iterator it = data_points_.begin();
         it != data_points_.end(); ++it) {

      int x = static_cast<int>(zoom_ * it->x) + center.x();
      int y = static_cast<int>(zoom_ * it->y) + center.y();

      //painter.drawLine(center, QPoint(x, y));
      painter.drawPoint(QPoint(x, y));
    }

    // 外枠を描画
    painter.setPen(QPen(Qt::black));
    painter.drawRect(widget_rect);
  }
};


RangeDataDrawWidget::RangeDataDrawWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  pimpl->initializeForm();
}


RangeDataDrawWidget::~RangeDataDrawWidget(void)
{
}


void RangeDataDrawWidget::redraw(void)
{
  // !!! データ更新がなく、操作がなければ、描画を行わないようにする
  update();
}


void RangeDataDrawWidget::paintEvent(QPaintEvent* event)
{
  static_cast<void>(event);

  pimpl->redraw();
}


void RangeDataDrawWidget::setData(const std::vector<qrk::Grid<int> >& points)
{
  pimpl->data_points_ = points;
}


double RangeDataDrawWidget::zoom(void)
{
  return pimpl->zoom_;
}


void RangeDataDrawWidget::setZoom(double zoom)
{
  pimpl->zoom_ = zoom;
}
