#ifndef CD_PLAYER_WIDGET_H
#define CD_PLAYER_WIDGET_H

/*!
  \file
  \brief CD-ROM プレイヤー

  \author Satofumi KAMIMURA

  $Id: CdPlayerWidget.h 195 2008-09-01 22:30:06Z satofumi $
*/

#include "ui_CdPlayerWidgetForm.h"


class CdPlayerWidget : public QWidget, private Ui::CdPlayerWidgetForm
{
  Q_OBJECT;

  CdPlayerWidget(const CdPlayerWidget& rhs);
  CdPlayerWidget& operator = (const CdPlayerWidget& rhs);

  struct pImpl;
  const std::auto_ptr<pImpl> pimpl;

public:
  CdPlayerWidget(QWidget* parent = 0);
  ~CdPlayerWidget(void);

public slots:
  void eject(void);
  void play(void);
  void pause(void);
  void stop(void);
  void next(void);
  void prev(void);
};

#endif /* !CD_PLAYER_WIDGET_H */
