/*!
  \file
  \brief CD-ROM の再生ウィジット

  \author Satofumi KAMIMURA

  $Id: CdPlayerWidget.cpp 195 2008-09-01 22:30:06Z satofumi $
*/

#include <QTimer>
#include <QShortcut>
#include "CdPlayerWidget.h"
#include "CdromPlay.h"

using namespace qrk;


struct CdPlayerWidget::pImpl
{
  CdPlayerWidget* parent_;
  CdromPlay cdrom_;
  std::vector<CdromPlay::track_t> tracks_;
  std::vector<CdromPlay::track_t> prev_tracks_;


  pImpl(CdPlayerWidget* parent) : parent_(parent)
  {
  }


  void initializeForm(void)
  {
    // Track テーブルの初期化
    QStringList labels;
    labels << "Track" << "Length";
    parent_->track_table_->setHorizontalHeaderLabels(labels);

    // 初期ボリューム値の取得
    // !!! CdromPlay から受け取った値で初期化すべき

    // ボタンイベントの登録
    connect(parent_->eject_button_, SIGNAL(clicked()), parent_, SLOT(eject()));
    connect(parent_->play_button_, SIGNAL(clicked()), parent_, SLOT(play()));
    connect(parent_->pause_button_, SIGNAL(clicked()), parent_, SLOT(pause()));
    connect(parent_->stop_button_, SIGNAL(clicked()), parent_, SLOT(stop()));
    connect(parent_->next_button_, SIGNAL(clicked()), parent_, SLOT(next()));
    connect(parent_->prev_button_, SIGNAL(clicked()), parent_, SLOT(prev()));

    // Ctrl-q で終了できるようにする
    (void) new QShortcut(Qt::CTRL + Qt::Key_Q, parent_, SLOT(close()));
  }


  void scanCdrom(void)
  {
    // !!! この処理が遅い。スレッド化すべき

    // 読み出してみて、それが現在の読み出し内容と異なるなら、テーブル内容を更新
    std::vector<CdromPlay::track_t> current_tracks;
    cdrom_.tracks(current_tracks);

    if (isSameTracks(current_tracks, tracks_)) {
      return;
    }
    std::swap(tracks_, current_tracks);

    // テーブル内容の更新
    fprintf(stderr, "update track table\n");
  }


  bool isSameTracks(std::vector<CdromPlay::track_t>& a,
                    std::vector<CdromPlay::track_t>& b)
  {
    if (a.size() != b.size()) {
      // そもそも、トラック長が異なる
      return false;
    }

    size_t n = a.size();
    for (size_t i = 0; i < n; ++i) {
      // !!! トラックのデータタイプも比較すべき
      if (a[i].frame_length != b[i].frame_length) {
        // トラックの長さが異なる
        return false;
      }
    }
    return true;
  }


  void play(void)
  {
    // !!!
  }


  void pause(void)
  {
    // !!!
  }


  void stop(void)
  {
    // !!!
  }


  void next(void)
  {
    // !!!
  }


  void prev(void)
  {
    // !!!
  }
};


CdPlayerWidget::CdPlayerWidget(QWidget* parent)
  : QWidget(parent), pimpl(new pImpl(this))
{
  setupUi(this);

  pimpl->initializeForm();
}


CdPlayerWidget::~CdPlayerWidget(void)
{
}


void CdPlayerWidget::eject(void)
{
  pimpl->cdrom_.eject();
}


void CdPlayerWidget::play(void)
{
  pimpl->play();
}


void CdPlayerWidget::pause(void)
{
  pimpl->pause();
}


void CdPlayerWidget::stop(void)
{
  pimpl->stop();
}


void CdPlayerWidget::next(void)
{
  pimpl->next();
}


void CdPlayerWidget::prev(void)
{
  pimpl->prev();
}
