#ifndef DRAW_FLOOR_WIDGET_H
#define DRAW_FLOOR_WIDGET_H

/*!
  \file
  \brief 床の描画ウィジット

  \author Satofumi KAMIMURA

  $Id: DrawFloorWidget.h 195 2008-09-01 22:30:06Z satofumi $
*/

#include <QGLWidget>


class DrawFloorWidget : public QGLWidget
{
  Q_OBJECT;

  DrawFloorWidget(const DrawFloorWidget& rhs);
  DrawFloorWidget& operator = (const DrawFloorWidget& rhs);

  struct pImpl;
  std::auto_ptr<pImpl> pimpl;

 protected:
  void initializeGL(void);
  void resizeGL(int width, int height);
  void paintGL(void);
  void mousePressEvent(QMouseEvent *event);
  void mouseMoveEvent(QMouseEvent *event);

public:
  DrawFloorWidget(QGLWidget* parent = 0);
  ~DrawFloorWidget(void);
};

#endif /* !DRAW_FLOOR_WIDGET_H */
