/*!
  \file
  \brief 足跡描画デモアプリのウィンドウ管理

  \author Satofumi KAMIMURA

  $Id: AshiPettanWindow.cpp 195 2008-09-01 22:30:06Z satofumi $
*/

#include "AshiPettanWindow.h"
#include "ConfigDialog.h"
#include "DrawFloorWidget.h"


struct AshiPettanWindow::pImpl
{
  AshiPettanWindow* parent_;
  ConfigDialog config_;
  DrawFloorWidget draw_widget_;


  pImpl(AshiPettanWindow* parent) : parent_(parent)
  {
  }


  void initializeForm(void)
  {
    // データ描画ウィンドウの配置
    parent_->main_layout_->addWidget(&draw_widget_);
    parent_->dummy_label_->hide();

    // メニュー
    connect(parent_->action_quit_, SIGNAL(triggered()), parent_, SLOT(close()));
    // !!!

    // 設定
    connect(parent_->config_button_, SIGNAL(clicked()),
            parent_, SLOT(config()));
  }
};


AshiPettanWindow::AshiPettanWindow(void) : QMainWindow(), pimpl(new pImpl(this))
{
  setupUi(this);

  pimpl->initializeForm();
}


AshiPettanWindow::~AshiPettanWindow(void)
{
}


void AshiPettanWindow::config(void)
{
  pimpl->config_.show();
}
