/*!
  \file
  \brief VRML 形式での点データ保存、読み出し

  \author Satofumi KAMIMURA

  $Id: vrmlPointHandler.cpp 246 2008-09-30 11:39:48Z satofumi $
*/

#include "vrmlPointHandler.h"
#include <fstream>


bool qrk::vrml_PointSave(const char* fname,
                         const std::vector<Grid3D<double> >& points,
                         const std::vector<Color>& colors)
{
  const char header[] =
    "#VRML V2.0 utf8\n"
    "Shape\n"
    "{\n"
    "  geometry PointSet\n"
    "  {\n";

  const char coord_header[] =
    "    coord Coordinate\n"
    "    {\n";

  const char point_header[] =
    "      point\n"
    "      [\n";

  const char point_footer[] =
    "      ]\n";

  const char coord_footer[] =
    "    }\n";

  const char color_header[] =
    "    color Color\n"
    "    {\n"
    "      color\n"
    "      [\n";

  const char color_footer[] =
    "      ]\n"
    "    }\n";

  const char footer[] =
    "  }\n"
    "}\n";

  std::ofstream fout(fname);
  if (! fout.is_open()) {
    return false;
  }

  // ヘッダ部の出力
  fout << header;

  // 点列データの出力
  fout << coord_header
       << point_header
       << "        # begin points." << std::endl;

  for (std::vector<Grid3D<double> >::const_iterator it = points.begin();
       it != points.end(); ++it) {
    fout << "        " << it->x << ' ' << it->y << ' ' << it->z << std::endl;
  }

  fout << "        # end points." << std::endl
       << point_footer
       << coord_footer;

  // 色データの出力
  fout << color_header;
  for (std::vector<Color>::const_iterator it = colors.begin();
       it != colors.end(); ++it) {
    fout << "        "
         << it->r << ' ' << it->g << ' ' << it->b
         << ',' << std::endl;
  }
  fout << color_footer;

  // フッタ部の出力
  fout << footer << std::endl;

  return true;
}

