/*!
  \file
  \brief 色を変更しながら点列を描画する

  \author Satofumi KAMIMURA

  $Id: colorPoints.cpp 130 2008-07-25 06:00:54Z satofumi $
*/

#include <stdio.h>
#include <cmath>
#include <vector>
#include "GridTypes.h"

using namespace qrk;


int main(int argc, char *argv[]) {

  enum { MaxLength = 5000 };

  // データの格納
  std::vector<Grid3D<int> > points;
  for (size_t i = 0; i < MaxLength; ++i) {
    points.push_back(Grid3D<int>(0, 0, i));
  }

  const char header[] =
    "#VRML V2.0 utf8\n"
    "Shape\n"
    "{\n"
    "  geometry PointSet\n"
    "  {\n";

  const char coord_header[] =
    "    coord Coordinate\n"
    "    {\n";

  const char point_header[] =
    "      point\n"
    "      [\n";

  const char point_footer[] =
    "      ]\n";

  const char coord_footer[] =
    "    }\n";

  const char color_header[] =
    "    color Color\n"
    "    {\n"
    "      color\n"
    "      [\n";

  const char color_footer[] =
    "      ]\n"
    "    }\n";

  const char footer[] =
    "  }\n"
    "}\n";

  // ヘッダ部の出力
  printf("%s", header);

  // 点列データの出力
  printf("%s", coord_header);
  printf("%s", point_header);
  for (std::vector<Grid3D<int> >::iterator it = points.begin();
       it != points.end(); ++it) {
    printf("        %d %d %f\n", it->x, it->y, -it->z / 1000.0);
  }
  printf("%s", point_footer);
  printf("%s", coord_footer);

  // 色データの出力
  printf("%s", color_header);
  for (std::vector<Grid3D<int> >::iterator it = points.begin();
       it != points.end(); ++it) {
    double length = sqrt((it->x * it->x) + (it->y * it->y) + (it->z * it->z));
    printf("        %f %f %f,\n",
           1.0 * (MaxLength - length) / MaxLength,
           0.8,
           1.0 * length / MaxLength);

  }
  printf("%s", color_footer);

  // フッタ部の出力
  printf("%s", footer);

  return 0;
}
