/*!
  \file
  \brief 画像の取得サンプル

  \author Satofumi KAMIMURA

  $Id: captureSample.cpp 219 2008-09-16 13:15:37Z satofumi $
*/

#include "CameraCtrl.h"
#include "delay.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  CameraCtrl camera;
  if (! camera.connect()) {
    printf("CameraCtrl::connect fail.\n");
    exit(1);
  }

  for (int i = 0; i < 3; ++i) {
    delay(1000);

    enum { BufferSize = 80 };
    char buffer[BufferSize];
    snprintf(buffer, BufferSize, "capture%d.jpg", i);

    if (! camera.capture(buffer)) {
      break;
    }
    printf("capture: %s\n", buffer);
  }
  return 0;
}
