#ifndef CAMERA_CTRL_H
#define CAMERA_CTRL_H

/*!
  \file
  \brief カメラ制御

  \author Satofumi KAMIMURA

  $Id: CameraCtrl.h 283 2008-10-19 21:31:36Z satofumi $
*/

#include <memory>


namespace qrk
{
  class CameraCtrl {
    CameraCtrl(const CameraCtrl& rhs);
    CameraCtrl& operator = (const CameraCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    CameraCtrl(void);
    ~CameraCtrl(void);

    const char* what(void);

    bool connect(void);
    void disconnect(void);

    void setCaptureSize(int width, int height);
    bool capture(const char* fileName = "capture.jpg");
  };
};

#endif /* !CAMERA_CTRL_H */
