/*!
  \file
  \brief カメラ制御

  \author Satofumi KAMIMURA

  $Id: CameraCtrl.cpp 283 2008-10-19 21:31:36Z satofumi $

  http://opencv.jp のサンプルより
*/

#include "CameraCtrl.h"
#include <highgui.h>


using namespace qrk;


struct CameraCtrl::pImpl
{
  CvCapture* capture_;


  pImpl(void) : capture_(NULL)
  {
  }
};


CameraCtrl::CameraCtrl(void) : pimpl(new pImpl)
{
}


CameraCtrl::~CameraCtrl(void)
{
}


const char* CameraCtrl::what(void)
{
  return "Not implemented.";
}


// !!! 複数カメラに対応できるようにする
// !!! 複数オブジェクトから同一カメラに接続しないための保証を実装すべき
bool CameraCtrl::connect(void)
{
  pimpl->capture_ = cvCreateCameraCapture(0);

  return (pimpl->capture_ == NULL) ? false : true;
}


void CameraCtrl::disconnect(void)
{
  if (pimpl->capture_) {
    cvReleaseCapture(&pimpl->capture_);
    pimpl->capture_ = NULL;
  }
}


void CameraCtrl::setCaptureSize(int width, int height)
{
  if (! pimpl->capture_) {
    return;
  }

  cvSetCaptureProperty(pimpl->capture_, CV_CAP_PROP_FRAME_WIDTH, width);
  cvSetCaptureProperty(pimpl->capture_, CV_CAP_PROP_FRAME_HEIGHT, height);
}


bool CameraCtrl::capture(const char* fileName)
{

  IplImage* frame = cvQueryFrame(pimpl->capture_);
  if (! frame) {
    return false;
  }

  if (! cvSaveImage(fileName, frame)) {
    return false;
  }

  return true;
}
