/*!
  \file
  \brief 条件変数の動作サンプル

  \author Satofumi KAMIMURA

  $Id: conditionVariableSample.cpp 260 2008-10-08 10:39:09Z satofumi $
*/

#include "ConditionVariable.h"
#include "Lock.h"
#include "Thread.h"
#include "delay.h"

#include <SDL.h>

using namespace qrk;


namespace
{
  int sample_thread(void* args)
  {
    ConditionVariable* condition = static_cast<ConditionVariable*>(args);

    printf("thread: waiting.\n");

    Lock mutex;
    mutex.lock();
    condition->wait(&mutex);

    printf("thread: I'm working.\n");

    return 0;
  }
};



int main(int argc, char *argv[])
{
  ConditionVariable condition;
  Thread thread(sample_thread, &condition);
  thread.run(1);

  // 条件変数で処理が開始されるのを確認する
  printf("main: wake up!\n");
  condition.wakeup();

  delay(100);

  return 0;
}
