/*!
  \file
  \brief ConvertStdStringPath のテスト

  \author Satofumi KAMIMURA

  $Id: TestConvertStdStringPath.cpp 166 2008-08-24 00:37:24Z satofumi $
*/

#include <QString>
#include "TestConvertStdStringPath.h"
#include "ConvertStdStringPath.h"

using namespace qrk;


CPPUNIT_TEST_SUITE_REGISTRATION(TestConvertStdStringPath);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestConvertStdStringPath,
                                      "TestConvertStdStringPath");


void TestConvertStdStringPath::toSjisTest(void)
{
  // ASCII 文字から SJIS への変換テスト (変化しないはず)
  const char* ascii_original = "desktop";
  std::string ascii_converted =
    toStdStringPath(QString(ascii_original), "Shift-JIS");
  CPPUNIT_ASSERT_EQUAL(std::string(ascii_original), ascii_converted);

  // UTF-8 から SJIS への変換テスト
  // UTF-8: 30c7, 30b9, 30af, 30c8, 30c3, 30d7 (デスクトップ)
  // SJIS:  8366, 8358, 834e, 8367, 8362, 8376
  QChar utf_original[] =
    { 0x30c7, 0x30b9, 0x30af, 0x30c8, 0x30c3, 0x30d7 };
  std::string utf_converted =
    toStdStringPath(QString(utf_original, 6), "Shift-JIS");

  const char expected_sjis[] = {
    0x83, 0x66, 0x83, 0x58, 0x83, 0x4e, 0x83, 0x67, 0x83, 0x62, 0x83, 0x76, 0x0
  };

  CPPUNIT_ASSERT_EQUAL(std::string(expected_sjis), utf_converted);
}
