/*!
  \file
  \brief ログの記録関数

  \author Satofumi KAMIMURA

  $Id: logPrintf.cpp 187 2008-08-30 10:26:11Z satofumi $

  \todo 出力ファイル名を変更できるようにする
*/

#include "logPrintf.h"
#include <stdio.h>
#include <stdarg.h>


int qrk::log_printf(const char *format, ...)
{
  static FILE* fd = NULL;
  if (fd == NULL) {
    fd = fopen("error_log.txt", "w");
    if (fd == NULL) {
      return -1;
    }
  }

  va_list ap;
  va_start(ap, format);

  int ret = vfprintf(fd, format, ap);
  va_end(ap);

  // fclose() する機会がないので、内容を書き出しておく
  fflush(fd);

  return ret;
}
