#ifndef DELAY_H
#define DELAY_H

/*!
  \file
  \brief 待機関数

  \author Satofumi KAMIMURA

  $Id: delay.h 222 2008-09-17 12:52:15Z satofumi $
*/


/*!
  \brief Quick Robot Development Kit
*/
namespace qrk
{
  /*!
    \brief 待機

    指定された時間だけ待機する

    \param[in] msec 待機時間 [msec]
  */
  void delay(int msec);

  /*!
    \brief 待機時間の速度変更

    \param[in] ratio delay() にて、指定時間 * ratio の時間だけ待機する
  */
  void setDelayRatio(double ratio);
};

#endif /* !DELAY_H */
