/*!
  \file
  \brief 一時停止可能なタイマー

  \author Satofumi KAMIMURA

  $Id: StopWatch.cpp 235 2008-09-26 12:47:48Z satofumi $
*/

#include "StopWatch.h"
#include "getTicks.h"

using namespace qrk;


struct StopWatch::pImpl
{
  enum {
    InvalidTicks = -1,
  };

  int start_ticks_;
  int pause_ticks_;


  pImpl(void)
  {
    initialize();
  }


  void initialize(void)
  {
    start_ticks_ = InvalidTicks;
    pause_ticks_ = InvalidTicks;
  }
};


StopWatch::StopWatch(void) : pimpl(new pImpl)
{
}


StopWatch::~StopWatch(void)
{
}


void StopWatch::start(void)
{
  if (pimpl->pause_ticks_ != pImpl::InvalidTicks) {
    // 一時停止の場合、再開させる
    resume();
    return;

  } else if (pimpl->start_ticks_ != pImpl::InvalidTicks) {
    // 再生中の場合は、戻る
    return;

  } else {
    // 停止中の場合は、開始する
    pimpl->start_ticks_ = qrk::getTicks();
  }
}


void StopWatch::stop(void)
{
  pimpl->initialize();
}


void StopWatch::pause(void)
{
  if ((pimpl->pause_ticks_ != pImpl::InvalidTicks) ||
      (pimpl->start_ticks_ == pImpl::InvalidTicks)) {
    // 一時停止、停止の場合、戻る
    return;
  }

  pimpl->pause_ticks_ = qrk::getTicks();
}


void StopWatch::resume(void)
{
  // 一時停止でなければ、戻る
  if (pimpl->pause_ticks_ == pImpl::InvalidTicks) {
    return;
  }

  int paused_msec = qrk::getTicks() - pimpl->pause_ticks_;
  pimpl->start_ticks_ += paused_msec;
  pimpl->pause_ticks_ = pImpl::InvalidTicks;
}


int StopWatch::getTicks(void)
{
  if (pimpl->start_ticks_ == pImpl::InvalidTicks) {
    // 停止
    return 0;

  } else if (pimpl->pause_ticks_ != pImpl::InvalidTicks) {
    // 一時停止
    int now_ticks = qrk::getTicks();

    return ((now_ticks - pimpl->start_ticks_)
            - (now_ticks - pimpl->pause_ticks_));

  } else {
    // 再生
    return qrk::getTicks() - pimpl->start_ticks_;
  }
}


bool StopWatch::isPause(void)
{
  return (pimpl->pause_ticks_ != pImpl::InvalidTicks) ? true : false;
}
