#ifndef LOCK_GUARD_H
#define LOCK_GUARD_H

/*!
  \file
  \brief ロックガードクラス

  \author Satofumi KAMIMURA

  $Id: LockGuard.h 166 2008-08-24 00:37:24Z satofumi $
*/

#include <memory>


namespace qrk
{
  class Lock;

  /*!
    \brief ロックガードクラス
  */
  class LockGuard
  {
    LockGuard(void);
    LockGuard(const LockGuard& rhs);
    LockGuard& operator = (const LockGuard& rhs);

    void* operator new (size_t);
    void* operator new[] (size_t);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    /*!
      \brief コンストラクタ

      \param[in] mutex ミューテックス資源
    */
    explicit LockGuard(qrk::Lock& mutex);
    ~LockGuard(void);
  };
};

#endif /* !LOCK_GUARD_H */
