#ifndef LOCK_H
#define LOCK_H

/*!
  \file
  \brief ロッククラス

  \author Satofumi KAMIMURA

  $Id: Lock.h 255 2008-10-06 11:31:15Z satofumi $
*/

#include "ConditionVariable.h"


namespace qrk
{
  /*!
    \brief ロッククラス
  */
  class Lock {

    friend class ConditionalVariable;
    friend bool ConditionVariable::wait(Lock* lock, int timeout);

    Lock(const Lock& rhs);
    Lock& operator = (const Lock& rhs);

    // !!! ?
    void* operator new (size_t);
    void* operator new[] (size_t);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    Lock(void);
    ~Lock(void);


    /*!
      \brief ロック
    */
    void lock(void);


    /*!
      \brief アンロック
    */
    void unlock(void);
  };
};

#endif /* !LOCK_GUARD_H */
