#ifndef CONDITION_VARIABLE_H
#define CONDITION_VARIABLE_H

/*!
  \file
  \brief 条件変数

  \author Satofumi KAMIMURA

  $Id: ConditionVariable.h 255 2008-10-06 11:31:15Z satofumi $
*/

#include <memory>


namespace qrk
{
  class Lock;

  class ConditionVariable
  {
    ConditionVariable(const ConditionVariable& rhs);
    ConditionVariable& operator = (const ConditionVariable& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      NoTimeout = -1,
    };
    ConditionVariable(void);
    ~ConditionVariable(void);

    bool isWaiting(void);
    void wakeup(void);
    void wakeupAll(void);

    bool wait(Lock* lock, int timeout = NoTimeout);
  };
};

#endif /* !CONDITION_VARIABLE_H */
