/*!
  \file
  \brief CdromPlay の動作サンプル

  \author Satofumi KAMIMURA

  $Id: cdromPlaySample.cpp 187 2008-08-30 10:26:11Z satofumi $
*/

#include "CdromPlay.h"
#include "delay.h"

using namespace qrk;


int main(int argc, char *argv[]) {

  // CD-ROM ドライブの存在を確認
  size_t drives = CdromPlay::drives();
  printf("CD-ROM Drives: %d\n", drives);
  if (drives == 0) {
    printf("no drive.\n");
    exit(1);
  }

  // トラック情報の取得と出力
  CdromPlay cdrom(0);
  std::vector<CdromPlay::track_t> tracks;
  if (! cdrom.tracks(tracks)) {
    printf("CdromPlay::getTrack: %s\n", cdrom.what());
    exit(1);
  }

  for (std::vector<CdromPlay::track_t>::iterator it = tracks.begin();
       it != tracks.end(); ++it) {
    if (it->type != CdromPlay::AudioTrack) {
      continue;
    }
    printf("track %2d: frame: %d, [%02d:%02d]\n",
           it->id, it->frame_length, it->min, it->sec);
  }

  // トラックを順番に再生
  size_t n = tracks.size();
  for (size_t i = 0; i < n; ++i) {
    int play_msec = cdrom.playTrack(i);
    if (play_msec < 0) {
      printf("CdromPlay::playTrack: %s\n", cdrom.what());
      exit(1);
    }
    printf("play track %d\n", i + 1);

    do {
      delay(500);
    } while (cdrom.isPlaying());
  }

  return 0;
}
