#ifndef SDL_MIXER_INIT_H
#define SDL_MIXER_INIT_H

/*!
  \file
  \brief SDL_mixer の初期化

  \author Satofumi KAMIMURA

  $Id: SdlMixerInit.h 167 2008-08-24 01:01:01Z satofumi $
*/

#include <memory>


namespace qrk
{
  /*!
    \brief SDL_MIXER システムの初期化クラス
  */
  class SdlMixerInit
  {
    SdlMixerInit(const SdlMixerInit& rhs);
    SdlMixerInit& operator = (const SdlMixerInit& rhs);

    struct pImpl;
    const std::auto_ptr<pImpl> pimpl;

  public:
    enum {
      ChannelNum = 8,
    };

    SdlMixerInit(void);
    ~SdlMixerInit(void);
  };
};

#endif /* !SDL_MIXER_INIT_H */
