/*!
  \file
  \brief SDL_mixer の初期化

  \author Satofumi KAMIMURA

  $Id: SdlMixerInit.cpp 167 2008-08-24 01:01:01Z satofumi $
*/

#include <SDL_mixer.h>
#include "SdlAudioInit.h"
#include "SdlMixerInit.h"

using namespace qrk;


struct SdlMixerInit::pImpl : private SdlAudioInit
{
  static bool initialized_;

  static void cleanUp(void) {
    Mix_AllocateChannels(0);
  }


  pImpl(void)
  {
    if (initialized_) {
      return;
    }

    if (Mix_OpenAudio(MIX_DEFAULT_FREQUENCY,
                      MIX_DEFAULT_FORMAT, MIX_DEFAULT_CHANNELS, 1024) < 0) {
      // !!! 例外を投げるべきかも
      return;
    }
    atexit(Mix_CloseAudio);

    Mix_AllocateChannels(ChannelNum);
    atexit(cleanUp);
    initialized_ = true;
  }
};
bool SdlMixerInit::pImpl::initialized_ = false;


SdlMixerInit::SdlMixerInit(void) : pimpl(new pImpl)
{
}


SdlMixerInit::~SdlMixerInit(void)
{
}
