/*!
  \file
  \brief SDL_CDROM システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlCdromInit.cpp 167 2008-08-24 01:01:01Z satofumi $

  \todo SdlSubsystemInit クラスを作るべきか検討する
*/

#include <SDL.h>
#include "SdlInit.h"
#include "SdlCdromInit.h"

using namespace qrk;


struct SdlCdromInit::pImpl : private SdlInit
{
  static bool initialized_;


  void init(void)
  {
    if (initialized_) {
      return;
    }
    initialized_ = (SDL_InitSubSystem(SDL_INIT_CDROM) < 0) ? false : true;
  }


  void quit(void)
  {
    // !!! 今のところ、この処理が明示的に呼ばれることは想定していない
    SDL_QuitSubSystem(SDL_INIT_CDROM);
    initialized_ = false;
  }
};
bool SdlCdromInit::pImpl::initialized_ = false;


SdlCdromInit::SdlCdromInit(void) : pimpl(new pImpl)
{
  pimpl->init();
}


SdlCdromInit::~SdlCdromInit(void)
{
  // exit() 時に SdlInit の実装内で SDL_Quit() が呼ばれるはずなので、何もしない
}
