/*!
  \file
  \brief SDL_AUDIO システムの初期化

  \author Satofumi KAMIMURA

  $Id: SdlAudioInit.cpp 167 2008-08-24 01:01:01Z satofumi $
*/

#include <SDL.h>
#include "SdlInit.h"
#include "SdlAudioInit.h"

using namespace qrk;


struct SdlAudioInit::pImpl : private SdlInit
{
  static bool initialized_;


  void init(void)
  {
    if (initialized_) {
      return;
    }
    initialized_ = (SDL_InitSubSystem(SDL_INIT_AUDIO) < 0) ? false : true;
  }


  void quit(void)
  {
    // !!! 今のところ、この処理が明示的に呼ばれることは想定していない
    SDL_QuitSubSystem(SDL_INIT_AUDIO);
    initialized_ = false;
  }
};
bool SdlAudioInit::pImpl::initialized_ = false;


SdlAudioInit::SdlAudioInit(void) : pimpl(new pImpl)
{
  pimpl->init();
}


SdlAudioInit::~SdlAudioInit(void)
{
  // exit() 時に SdlInit の実装内で SDL_Quit() が呼ばれるはずなので、何もしない
}
