/*!
  \file
  \brief Watch dog timer 機能

  \author Satofumi KAMIMURA

  $Id: wdt_ctrl.c 166 2008-08-24 00:37:24Z satofumi $

  \todo スタンバイモード実装時に作り直す
*/

#include "wdt_ctrl.h"
#include "cpu_akiduki.h"


/*!
  \todo 必要に応じて、より細かなカウントに対応する
*/
void wdt_start(wdt_wait_t wait_time)
{
  if (wait_time >= WDT_WAIT_LAST) {
    return;
  }

  WDT.WRITE.RSTCSR = 0xa500;        // WOVF := 1
  WDT.WRITE.RSTCSR = 0x5a7f;        // RSTE := 1
  WDT.WRITE.TCSR = 0xa578 | wait_time;
}


void wdt_stop(void)
{
  WDT.WRITE.TCSR = 0xa51f;
}


void wdt_touch(void)
{
  WDT.WRITE.TCSR = 0x5a00;
}
