/*!
  \file
  \brief WDT の動作サンプル

  \author Satofumi KAMIMURA

  $Id: wdt_reset.c 246 2008-09-30 11:39:48Z satofumi $
*/

#include "wdt_ctrl.h"
#include "sci_put.h"
#include "timer_ctrl.h"
#include "imask_ctrl.h"

enum {
  SCI_PORT = SCI_1,
  TIMER_PORT = TIMER_0,
};


static void timer_handler(void) {
  static int msec = 0;
  static int sec = 0;
  static int wdt_msec = 0;

  // ２秒以上経過したら、WDT を touch しない
  ++msec;
  if (msec > 1000) {
    ++sec;
    msec = 0;
    sci_putchar(SCI_PORT, '.');
  }
  if (sec >= 2) {
    return;
  }

  ++wdt_msec;
  if (wdt_msec > 70) {
    wdt_touch();
  }
}


void __main(void) {}
int main(void) {

  sci_initialize(SCI_PORT, 6);
  imask_setMaskLevel(0);
  timer_initialize(TIMER_PORT, 4, 1000, timer_handler);

  sci_puts(SCI_PORT, "wdt sample\r\n");
  timer_start(TIMER_PORT);
  wdt_start(WDT_73_MSEC);

  while (1)
    ;
}
