/*!
  \file
  \brief １秒毎の文字表示

  \author Satofumi KAMIMURA

  $Id: timer1sec.c 246 2008-09-30 11:39:48Z satofumi $
*/

#include "sci_put.h"
#include "imask_ctrl.h"
#include "timer_ctrl.h"


enum {
  SCI_PORT = SCI_1,
  TIMER_PORT = TIMER_0,
};

static void timer_handler(void) {
  static int msec = 0;
  static int sec = 0;

  ++msec;
  if (msec >= 1000) {
    ++sec;
    msec = 0;
    sci_putchar(SCI_PORT, '.');
  }
  if (sec >= 10) {
    timer_stop(TIMER_PORT);
    sci_puts(SCI_PORT, "stop\r\n");
  }
}


void __main(void) {}
int main(void) {

  sci_initialize(SCI_PORT, 6);
  imask_setMaskLevel(0);

  sci_puts(SCI_PORT, "start\r\n");

  timer_initialize(TIMER_PORT, 4, 1000, timer_handler);
  timer_start(TIMER_PORT);

  while (1)
    ;
}
