/*!
  \file
  \brief IO の操作サンプル

  \author Satofumi KAMIMURA

  $Id: io_sample.c 223 2008-09-20 02:19:33Z satofumi $
*/

#include "sci_put.h"
#include "imask_ctrl.h"
#include <7040S.H>


enum {
  PORT = SCI_1,
};


//! メイン関数
void __main(void) {}

//! メイン関数
int main(void) {

  // シリアル通信の初期化
  sci_initialize(PORT, 4);
  imask_setMaskLevel(0);

  // PE14 を出力設定 (Default Lo)
  PFC.PECR1.WORD &= ~0x3000;
  PFC.PEIOR.WORD |= 0x4000;
  PE.DR.WORD &= ~0x4000;

  // １文字受信毎に出力を変更する
  while (1) {
    char ch;

    // Hi
    while (sci_read(PORT, &ch, 1) == 0)
      ;
    PE.DR.WORD |= 0x4000;
    sci_puts(PORT, "Hi !\r\n");
    sci_flush(PORT);

    // Lo
    while (sci_read(PORT, &ch, 1) == 0)
      ;
    PE.DR.WORD &= ~0x4000;
    sci_puts(PORT, "Lo\r\n");
    sci_flush(PORT);
  }
}
