/*!
  \file
  \brief エコーバックプログラム

  \author Satofumi KAMIMURA

  $Id: echoback.c 223 2008-09-20 02:19:33Z satofumi $
*/

#include "sci_put.h"
#include "sci_get.h"
#include "imask_ctrl.h"


enum { PORT = SCI_1 };

void __main(void) {}
int main(void) {

  sci_initialize(PORT, 4);
  imask_setMaskLevel(0);

  sci_puts(PORT, "echoback program begin.\r\n");

  while (1) {
    char ch;
    int i = sci_read(PORT, &ch, 1);
    if (ch >= 'a' && ch <= 'z') {
      ch += 'A' - 'a';
    }
    if (i > 0) {
      sci_write(PORT, &ch, 1);
    }
  }

  return 0;
}
