# Makeifle for SH2 program compile
# Satofumi KAMIMURA
# $Id$

# Compile command settings
CC_FOR_BUILD = ${ARCH}-gcc
CXX_FOR_BUILD = ${ARCH}-g++
AS_FOR_BUILD = ${ARCH}-as
LD_FOR_BUILD = ${ARCH}-ld
AR_FOR_BUILD = ${ARCH}-ar
OBJ_COPY_FOR_BUILD = ${ARCH}-objcopy
OBJ_DUMP_FOR_BUILD = ${ARCH}-objdump

# Suffix rules
.SUFFIXES : .rom .mot .dis .rom_dis .cof .o .c .h .S

.c.o:
	${CC_FOR_BUILD} ${CFLAGS_FOR_BUILD} -c $<

.S.o:
	${CC_FOR_BUILD} ${CFLAGS_FOR_BUILD} -c $<

.o.cof:
	${CC_FOR_BUILD} ${LDFLAGS_FOR_BUILD} -T ${LD_LOAD_FOR_BUILD} $^ -o $@ ${LDLIBS_FOR_BUILD}

.cof.mot:
#	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 --srec-forceS3 -O srec $< $@
#	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 -O srec $< $@
	${OBJ_COPY_FOR_BUILD} -O srec $< $@
	@chmod a-x $@

.cof.dis:
	${OBJ_DUMP_FOR_BUILD} -D --disassemble-zeroes $< > $@
#	${OBJ_DUMP_FOR_BUILD} -D $< > $@

.o.rom:
	${CC_FOR_BUILD} ${LDFLAGS_FOR_BUILD} -T ${LD_ROM_FOR_BUILD} $^ -o $@.tmp ${LDLIBS_FOR_BUILD}
#	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 --srec-forceS3 -O srec $@.tmp $@
	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 -O srec $@.tmp $@
	@${RM} $@.tmp
	@chmod a-x $@

.o.rom_dis:
	${CC_FOR_BUILD} ${LDFLAGS_FOR_BUILD} -T ${LD_ROM_FOR_BUILD} $^ -o $@.tmp ${LDLIBS_FOR_BUILD}
	${OBJ_DUMP_FOR_BUILD} -D $@.tmp > $@
	@${RM} $@.tmp

(%): %
	${AR_FOR_BUILD} ${ARFLAGS_FOR_BUILD} $@ $<
