/*!
  \file
  \brief 割り込みマスク制御

  \author Satofumi KAMIMURA

  $Id: imask_ctrl.c 223 2008-09-20 02:19:33Z satofumi $
*/

#include "imask_ctrl.h"


void imask_setMaskLevel(int level)
{
  int srreg;

  level <<= 4;
  level &= 0x00f0;
  asm("stc        sr, %0 ": "=r"(srreg):);
  srreg &= 0xffffff0f;
  srreg |= level;
  asm("ldc        %0, sr ": :"r"(srreg));
}


/* 割り込みマスクの取得 */
int imask_maskLevel(void)
{
  unsigned int mask;

  asm("stc        sr, %0 ": "=r"(mask):);
  mask &= ~0xffffff0f;
  mask >>= 4;

  return mask;
}
