! start up rutine for SH7045F(alpha project)
! Satofumi KAMIMURA
! $Id: crt0.S,v 1.1 2004/06/09 01:07:20 satofumi Exp $
!
	.text
	.global	start
start:
	bsr bus_init
	nop

	! check ROM or RAM
	mov.l	data_k, r0
	mov.l	cp_start_k, r1
	cmp/eq	r0, r1
	bt	start_main

	! copy data & clear bss section
	mov.l	cp_end_k, r2
	cmp/eq	r1, r2		! needless copy
	bt	start_main

copy_l:
	mov.l	@r1+, r3
	mov.l	r3, @r0
	add	#4, r0
	cmp/gt	r0, r2
	bt	copy_l

start_main:
	mov.l	stack_k,r15
	mov.l	vec_k, r0	! vbr initialize
	ldc	r0, vbr

	! zero out bss
	mov.l	edata_k,r0
	mov.l	end_k,r1
	mov	#0,r2
start_l:
	mov.l	r2,@r0
	add	#4,r0
	cmp/ge	r0,r1
	bt	start_l

#if defined (__SH3E__) || defined(__SH4_SINGLE__) || defined(__SH4__) || defined(__SH4_SINGLE_ONLY)
	mov.l set_fpscr_k, r1
	jsr @r1
	mov #0,r4
	lds r3,fpscr
#endif /*  defined (__SH3E__) || defined(__SH4_SINGLE__) || defined(__SH4__) || defined(__SH4_SINGLE_ONLY__) */

	! call the mainline
	mov.l	main_k,r0
	jsr	@r0
	or	r0,r0

	nop
inf_loop:
	bra	inf_loop
	nop

! Bus initialize
bus_init:
	mov.l	BCR1,r2
	mov.w	BCR1_D, r0	! CS0 16
	mov.w	r0, @r2

	mov.l	BCR2,r2
	mov.w	BCR2_D, r0	! CS0~CS3 1 idle-cycle
	mov.w	r0, @r2

	mov.l	WCR1,r2
	mov.w	WCR1_D,r0
	mov.w	r0, @r2

	mov.l	PACRH,r2
	mov.w	PACRH_D, r0	! WRHH WRHL PA21~16
	mov.w	r0, @r2

	mov.l	PACRL1,r2
	mov.w	PACRL1_D, r0	! CK RD WRH WRL CS1 CS0 PA9,8
	mov.w	r0, @r2

	mov.l	PACRL2, r2	! enable RxD1, TxD1
	mov.w	PACRL2_D, r0
	mov.w	r0, @r2

	mov.l	PBCR1,r2
	mov.w	PBCR1_D, r0
	mov.w	r0, @r2		! A21/A20

	mov.l	PBCR2,r2
	mov.w	PBCR2_D, r0 	! A19-A16
	mov.w	r0,@r2

	mov.l	PCCR,r2
	mov.w	PCCR_D, r0 	! A15-A0
	mov.w	r0,@r2

	mov.l	PDCRH1,r2
	mov.w	PDCRH1_D,r0 	! D31-D24
	mov.w	r0,@r2

	mov.l	PDCRH2,r2
	mov.w	PDCRH2_D,r0 	! D23-D16
	mov.w	r0,@r2

	mov.l	PDCRL,r2
	mov.w	PDCRL_D,r0 	! D0-D7
	mov.w	r0,@r2

	rts
	nop

	.align	4
BCR1:		.long	0xffff8620
BCR2:		.long	0xffff8622
WCR1:		.long	0xffff8624
PACRH:		.long	0xffff8388
PACRL1:		.long	0xffff838c
PACRL2:		.long	0xffff838e
PBCR1:		.long	0xffff8398
PBCR2:		.long	0xffff839a
PCCR:		.long	0xffff839c
PDCRH1:		.long	0xffff83a8
PDCRH2:		.long	0xffff83aa
PDCRL:		.long	0xffff83ac
PECR1:		.long	0xffff83b8

	.align 2
BCR1_D:		.word	0x20ff
BCR2_D:		.word	0x0000
WCR1_D:		.word	0x0000
PACRH_D:	.word	0x5000
PACRL1_D:	.word	0x5550
PACRL2_D:	.word	0x0140
PBCR1_D:	.word	0x000a
PBCR2_D:	.word	0xa005
PCCR_D:		.word	0xffff
PDCRH1_D:	.word	0x5555
PDCRH2_D:	.word	0x5555
PDCRL_D:	.word	0xffff
PECR1_D:	.word	0x0000

	.align 2
#if defined (__SH3E__) || defined(__SH4_SINGLE__) || defined(__SH4__) || defined(__SH4_SINGLE_ONLY__)
set_fpscr_k:
	.long	___set_fpscr
#endif /*  defined (__SH3E__) || defined(__SH4_SINGLE__) || defined(__SH4__) || defined(SH4_SINGLE_ONLY) */
stack_k:	.long	_stack
vec_k:		.long	_vec_ram
edata_k:	.long	_edata
end_k:		.long	_end
main_k:		.long	_main
data_k:		.long	_data_start
cp_start_k:	.long	_cp_start
cp_end_k:	.long	_cp_end

#ifdef __ELF__
	.section .stack,"aw"
#else
	.section .stack
#endif
!_stack:	.long	0xdeaddead
