/*!
  \file
  \brief ring_buffer のテスト

  \author Satofumi KAMIMURA

  $Id: Test_ring_buffer.cpp 130 2008-07-25 06:00:54Z satofumi $
*/

#include "Test_ring_buffer.h"
#include "ring_buffer.h"


CPPUNIT_TEST_SUITE_REGISTRATION(RingBufferTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(RingBufferTest, "RingBufferTest");


void RingBufferTest::putTest(void) {

  ringBuffer_t ring;
  char buffer[] = { '\0', '\0' };
  char ch;
  int n;

  ring_init(&ring, (unsigned char *)buffer, 1);
  CPPUNIT_ASSERT_EQUAL(0, ring_size(&ring));

  ring_write(&ring, (const unsigned char *)"0", 1);
  CPPUNIT_ASSERT_EQUAL(1, ring_size(&ring));

  n = ring_read(&ring, (unsigned char *)&ch, 1);
  CPPUNIT_ASSERT_EQUAL('0', buffer[0]);
  CPPUNIT_ASSERT_EQUAL(1, n);

  ring_clear(&ring);
  CPPUNIT_ASSERT_EQUAL(0, ring_size(&ring));
}


void RingBufferTest::rotateTest(void) {

  ringBuffer_t ring;
  char buffer[] = { '\0', '\0', '\0', '\0', };
  char recv_buffer[] = { '\0', '\0', '\0', '\0', };
  char ch;
  int n;

  ring_init(&ring, (unsigned char *)buffer, 2);

  for (int i = 0; i < 3; ++i) {
    char ch = '0' + i;
    n = ring_write(&ring, (unsigned char *)&ch, 1);
    CPPUNIT_ASSERT_EQUAL(1, n);
  }

  n = ring_size(&ring);
  CPPUNIT_ASSERT_EQUAL(3, n);

  n = ring_read(&ring, (unsigned char *)recv_buffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, n);
  CPPUNIT_ASSERT_EQUAL(std::string("012"), std::string(recv_buffer));

  ring_write(&ring, (unsigned char *)"abc", 3);
  n = ring_read(&ring, (unsigned char *)recv_buffer, 3);
  CPPUNIT_ASSERT_EQUAL(3, n);
  CPPUNIT_ASSERT_EQUAL(std::string("abc"), std::string(recv_buffer));
}
