#ifndef LUA_HANDLER_H
#define LUA_HANDLER_H

/*!
  \file
  \brief Lua の処理をクラス化

  \author Satofumi KAMIMURA

  $Id: LuaHandler.h 269 2008-10-11 12:33:26Z satofumi $
*/

extern "C"
{
#include <lua.h>
}
#include <memory>


namespace qrk
{
  class LuaHandler
  {
    LuaHandler(void);
    LuaHandler(const LuaHandler& rhs);
    LuaHandler& operator = (const LuaHandler& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    static LuaHandler* singleton(void);
    ~LuaHandler(void);
    lua_State* luaPointer(void);

    int doFile(const char* file_name);
    int doString(const char* lua_command);
  };
};

#endif /* !LUA_HANDLER_H */
