/*!
  \file
  \brief Lua の処理をクラス化

  \author Satofumi KAMIMURA

  $Id: LuaHandler.cpp 269 2008-10-11 12:33:26Z satofumi $
*/

#include "LuaHandler.h"
extern "C" {
#include <lualib.h>
#include <lauxlib.h>
}

using namespace qrk;


struct LuaHandler::pImpl
{
  lua_State* lua_;


  pImpl(void) : lua_(lua_open())
  {
    luaL_openlibs(lua_);
  }


  ~pImpl(void)
  {
    lua_close(lua_);
  }
};


LuaHandler::LuaHandler(void) : pimpl(new pImpl)
{
}


LuaHandler* LuaHandler::singleton(void)
{
  static LuaHandler singleton;
  return &singleton;
}


LuaHandler::~LuaHandler(void)
{
}


lua_State* LuaHandler::luaPointer(void)
{
  return pimpl->lua_;
}


int LuaHandler::doFile(const char* file_name)
{
  return luaL_dofile(pimpl->lua_, file_name);
}


int LuaHandler::doString(const char* lua_command)
{
  return luaL_dostring(pimpl->lua_, lua_command);
}
