#ifndef WHEEL_CTRL_H
#define WHEEL_CTRL_H

/*!
  \file
  \brief 車輪制御

  \author Satofumi KAMIMURA

  $Id: wheel_ctrl.h 210 2008-09-03 12:48:02Z satofumi $
*/

#include "servo_mode.h"
#include "rotational_direction.h"


extern void wheel_initialize(int id);

extern ServoMode wheel_servo(void);
extern void wheel_setServo(ServoMode servo_mode);


/*!
  \brief 車輪回転方向の設定

  正の値を与えたときの、車輪の回転方向を設定する。
*/
extern void motor_setRotationalDirection(int id,
                                         const RotationalDirection
                                         rotational_direction);
extern RotationalDirection motor_rotationalDirection(int id);


extern void wheel_setVeloctiy(int id, int mm_sec);


// !!! 車輪１周あたりのエンコーダ変位量
extern int wheel_totalEncoderCount(int id);

#endif /* !WHEEL_CTRL_H */
