/*!
  \file
  \brief pwm_ctrl の動作サンプル

  \author Satofumi KAMIMURA

  $Id: pwm_ctrl_test.c 232 2008-09-23 15:53:44Z satofumi $
*/

#include "sci_put.h"
#include "sci_get.h"
#include "imask_ctrl.h"
#include "motor_ctrl.h"
#include "pwm_ctrl.h"

enum {
  SCI_Port = SCI_1,
};


void __main(void) {}
int main(void)
{
  motor_t motor[2];
  int duty = 0;
  int i;

  sci_initialize(SCI_Port, 4);
  imask_setMaskLevel(0);

  for (i = 0; i < 2; ++i) {
    motor_initialize(&motor[i], i);
    motor_setServo(&motor[i], ServoCW);
  }

  // +, - のキー入力で duty を 10 ずつ変更する
  sci_puts(SCI_Port, "duty change: '+', '-'\r\n");

  duty = 0;
  while (1) {
    char ch = sci_getchar(SCI_Port);
    if (ch == '+') {
      duty += 10;
    } else if (ch == '-') {
      duty -= 10;
    } else {
      continue;
    }

    if (duty > 255) {
      duty = 255;
    } else if (duty < 0) {
      duty = 0;
    }
    sci_putint(SCI_Port, duty);
    sci_puts(SCI_Port, "\r\n");
    sci_flush(SCI_Port);

    for (i = 0; i < 2; ++i) {
      pwm_setDuty(i, duty);
    }
  }
}
