/*!
  \file
  \brief motor_ctrl の動作サンプル

  \author Satofumi KAMIMURA

  $Id: motor_ctrl_test.c 233 2008-09-24 21:19:15Z satofumi $
*/

#include "sci_put.h"
#include "sci_get.h"
#include "timer_ctrl.h"
#include "imask_ctrl.h"
#include "motor_ctrl.h"
#include "pwm_ctrl.h"
#include "encoder_ctrl.h"

enum {
  SCI_Port = SCI_1,
  Timer_Port = TIMER_0,
};


static volatile int Count_per_msec = 0;
static motor_t Motor[2];
static encoder_t Encoder[2];


static void msec_handler(void)
{
  int i;

  for (i = 0; i < 2; ++i) {
    encoder_update(&Encoder[i]);
  }

  for (i = 0; i < 2; ++i) {
    int count_velocity = encoder_differentialCount(&Encoder[i]);
    motor_setRotationalVelocity(&Motor[i], Count_per_msec, count_velocity);
  }
}


void __main(void) {}
int main(void)
{
  enum {
    CountMax = 255,
  };
  int i;

  sci_initialize(SCI_Port, 4);
  timer_initialize(Timer_Port, 2, 1000, msec_handler);
  imask_setMaskLevel(0);

  for (i = 0; i < 2; ++i) {
    motor_initialize(&Motor[i], i);
    encoder_initialize(&Encoder[i], i);
  }

  // +, - のキー入力で duty を 10 ずつ変更する
  sci_puts(SCI_Port, "duty change: '+', '-'\r\n");
  timer_start(Timer_Port);

  while (1) {
    char ch = sci_getchar(SCI_Port);
    if (ch == '+') {
      Count_per_msec += 10;
    } else if (ch == '-') {
      Count_per_msec -= 10;
    } else {
      continue;
    }

    if (Count_per_msec > CountMax) {
      Count_per_msec = CountMax;
    } else if (Count_per_msec < -CountMax) {
      Count_per_msec = -CountMax;
    }
    sci_putint(SCI_Port, Count_per_msec);
    sci_puts(SCI_Port, "\r\n");
    sci_flush(SCI_Port);
  }
}
