/*!
  \file
  \brief encoder_ctrl の動作サンプル

  \author Satofumi KAMIMURA

  $Id: encoder_ctrl_test.c 256 2008-10-06 11:50:34Z satofumi $
*/

#include "sci_put.h"
#include "sci_get.h"
#include "timer_ctrl.h"
#include "imask_ctrl.h"
#include "encoder_ctrl.h"
#include "motor_ctrl.h"

enum {
  SCI_Port = SCI_1,
  Timer_Port = TIMER_0,
};

static encoder_t Encoder[2];
static motor_t Motor[2];


// 1 [sec] 毎に、そのときのカウンタ変位を表示
static void msec_handler(void)
{
  static int msec = 0;
  int i;

  for (i = 0; i < 2; ++i) {
    encoder_update(&Encoder[i]);
  }

  if (++msec >= 1000) {
    msec = 0;

    for (i = 0; i < 2; ++i) {
      int counter_velocity = encoder_differentialCount(&Encoder[i]);
      sci_putint(SCI_Port, counter_velocity);
      sci_puts(SCI_Port, "\t");
    }
    sci_puts(SCI_Port, "\r\n");
  }
}


void __main(void) {}
int main(void)
{
  int i;

  sci_initialize(SCI_Port, 4);
  timer_initialize(Timer_Port, 2, 1000, msec_handler);
  imask_setMaskLevel(0);

  for (i = 0; i < 2; ++i) {
    encoder_initialize(&Encoder[i], i);

    motor_initialize(&Motor[i], i);
    motor_setServo(&Motor[i], ServoFree);
  }

  timer_start(Timer_Port);

  while (1) {
    ;
  }
}
