/*!
  \file
  \brief PWM 出力制御

  \author Satofumi KAMIMURA

  $Id: pwm_ctrl.c 223 2008-09-20 02:19:33Z satofumi $
*/

#include "pwm_ctrl.h"
#include <7040S.H>


void pwm_initialize(char id)
{
  // 共通設定
  MTU3.TCR.BYTE = 0x20 | 0x01;	/* cycle=TGRA, duty=TGRB, cycle/4 */
  MTU3.TMDR.BYTE = 0xc2;	/* pwm mode 1, buffer disable */

  PFC.PECR1.WORD &= ~0x0044;	/* TIOC3B, TIOC3D */
  PFC.PECR2.WORD &= ~0x4400;	/* TIOC1B, TIOC2B */
  PFC.PEIOR.WORD |= 0x0aa0;     /* mode output */

  if (id == 0) {
    PFC.PEIOR.WORD |= 0x0100;	/* use TIOC3A port */
    MTU3.TIOR.BYTE.H = 0x12;	/* TGR3B=1, TGR3A=0 */
    MTU3.TGRA = 255;            /* cycle */
    PFC.PECR1.WORD |= 0x0001;	/* use TGRA, TGRC port */

    PE.DR.WORD &= ~0x0100;

  } else if (id == 1) {
    PFC.PEIOR.WORD |= 0x0400;	/* use TIOC3C port */
    MTU3.TIOR.BYTE.L = 0x12;	/* TGR3D=1, TGR3C=0 */
    MTU3.TGRC = 255;            /* cycle */
    PFC.PECR1.WORD |= 0x0010;	/* use TGRA, TGRC port */

    PE.DR.WORD &= ~0x0400;
  }

  MTU.TSTR.BYTE |= 0xc0;	/* pwm active */
}


void pwm_setDuty(char id, int duty)
{
  if (id == 0) {
    if ((duty <= 0) || (duty >= 255)) {
      PFC.PECR1.WORD &= ~0x0001; /* PE8 */
      PE.DR.WORD &= ~0x0100;
      PE.DR.WORD |= (duty <= 0) ? 0 : 0x0100;
    } else {
      PFC.PECR1.WORD |= 0x0001; /* TIOC3A */
      MTU3.TGRB = duty;
    }
  } else if (id == 1) {
    if ((duty <= 0) || (duty >= 255)) {
      PFC.PECR1.WORD &= ~0x0010; /* PE10 */
      PE.DR.WORD &= ~0x0400;
      PE.DR.WORD |= (duty <= 0) ? 0 : 0x0400;
    } else {
      PFC.PECR1.WORD |= 0x0010; /* TIOC3C */
      MTU3.TGRD = duty;
    }
  }
}
