#ifndef MOTOR_CTRL_H
#define MOTOR_CTRL_H

/*!
  \file
  \brief モータ制御

  \author Satofumi KAMIMURA

  $Id: motor_ctrl.h 222 2008-09-17 12:52:15Z satofumi $
*/

#include "motor_t.h"


extern void motor_initialize(motor_t *motor, char id);

extern void motor_setServo(motor_t *motor, const ServoMode servo_mode);
extern ServoMode motor_servo(motor_t *motor);


/*!
  \brief モータ回転方向の設定

  正の値を与えたときの、モータ軸の回転方向を設定する。
*/
extern void motor_setRotationalDirection(motor_t *motor,
                                         const RotationalDirection direction);
extern RotationalDirection motor_rotationalDirection(motor_t *motor);


/*!
  \brief モータ回転速度の設定

  msec あたりのエンコーダの変位を制御する
*/
extern void motor_setRotationalVelocity(motor_t *motor,
                                        int target_count, int now_count);

#endif /* !MOTOR_CTRL_H */
