/*!
  \file
  \brief モータ制御

  \author Satofumi KAMIMURA

  $Id: motor_ctrl.c 223 2008-09-20 02:19:33Z satofumi $
*/

#include "motor_ctrl.h"
#include "pwm_ctrl.h"
#include <7040S.H>


void motor_initialize(motor_t *motor, char id)
{
  motor->id = id;
  motor->servo_mode = ServoUnknown;
  motor->rotational_direction = CW;

  motor_setServo(motor, ServoFree);

  pwm_initialize(id);
  pwm_setDuty(id, 0);
}


void motor_setServo(motor_t *motor, const ServoMode servo_mode)
{
  char id = motor->id;
  if (id == 0) {
    /* DIR(PE5), EN(PE7) */
    if (servo_mode == ServoCCW) {
      PE.DR.WORD |= 0x0020;	/* DIR(PE5)=1 */
      PE.DR.WORD &= ~0x0080;	/* EN(PE7)=0 */

    } else if (servo_mode == ServoCW) {
      PE.DR.WORD &= ~0x0020;	/* DIR(PE5)=1 */
      PE.DR.WORD &= ~0x0080;	/* EN(PE7)=0 */

    } else {			/* MTR_MODE_FREE */
      PE.DR.WORD |= 0x0080;	/* EN(PE7)=1 */
    }
    motor->servo_mode = servo_mode;

  } else if (id == 1) {
    /* DIR(PE9), EN(PE11) */
    if (servo_mode == ServoCCW) {
      PE.DR.WORD |= 0x0200;	/* DIR(PE9)=1 */
      PE.DR.WORD &= ~0x0800;	/* EN(PE11)=1 */

    } else if (servo_mode == ServoCW) {
      PE.DR.WORD &= ~0x0200;	/* DIR(PE9)=0 */
      PE.DR.WORD &= ~0x0800;	/* EN(PE11)=1 */

    } else {			/* MTR_MODE_FREE */
      PE.DR.WORD |= 0x0800;	/* EN(PE11)=1 */
    }
    motor->servo_mode = servo_mode;
  }
}


ServoMode motor_servo(motor_t *motor)
{
  return motor->servo_mode;
}


void motor_setRotationalDirection(motor_t *motor,
                                  const RotationalDirection direction)
{
  motor->rotational_direction = direction;
}


RotationalDirection motor_rotationalDirection(motor_t *motor)
{
  return motor->rotational_direction;
}


void motor_setRotationalVelocity(motor_t *motor,
                                 int target_count, int now_count)
{
  char id = motor->id;
  if (id == 0) {
    // !!!

  } else if (id == 1) {
    // !!!
  }
}
