/*!
  \file
  \brief エンコーダ値の取得

  \author Satofumi KAMIMURA

  $Id: encoder_ctrl.c 255 2008-10-06 11:31:15Z satofumi $
*/

#include "encoder_ctrl.h"
#include <7040S.H>


void encoder_initialize(encoder_t *encoder, char id)
{
  encoder->id = id;

  if (id == 0) {
    MTU1.TMDR.BYTE = 0xc4;        /* encoder mode 1 */
    MTU.TSTR.BYTE |= 0x02;        /* start count up */
    PFC.PECR2.WORD |= 0x0100;     /* TIOC1A */
    MTU1.TIOR.BYTE = 0x0a;        /* input capture */
    PFC.PEIOR.WORD &= ~0x0010;    /* use TIOC2A port */
    PFC.PACRL2.WORD &= ~0xf000;   /* TCLKA, TCLKB */
    PFC.PACRL2.WORD |= 0x5000;

    MTU1.TCNT = 0;                /* counter=0 */
    MTU1.TGRA = 0;                /* buffer=0 */

  } else if (id == 1) {
    MTU2.TMDR.BYTE = 0xc4;        /* encoder mode 1 */
    MTU.TSTR.BYTE |= 0x04;        /* start count up */
    PFC.PECR2.WORD |= 0x1000;     /* TIOC2A */
    MTU2.TIOR.BYTE = 0x0a;        /* input capture */
    PFC.PEIOR.WORD &= ~0x0040;    /* use TIOC1A port */
    PFC.PACRL1.WORD &= ~0x000f;   /* TCLKC, TCLKD */
    PFC.PACRL1.WORD |= 0x0005;

    MTU2.TCNT = 0;
    MTU2.TGRA = 0;
  }
}


void encoder_update(encoder_t *encoder)
{
  char id = encoder->id;
  int current_count = encoder->previous_count;
  if (id == 0) {
    current_count = MTU1.TCNT;

  } else if (id == 1) {
    current_count = MTU2.TCNT;
  }
  encoder->previous_count = encoder->current_count;
  encoder->current_count = current_count;

  encoder->total_count += encoder->previous_count - current_count;
}


int encoder_differentialCount(encoder_t *encoder)
{
  short differential_count = encoder->current_count - encoder->previous_count;
  return differential_count;
}


int encoder_count(encoder_t *encoder)
{
  return encoder->total_count;
}


void encoder_setCount(encoder_t *encoder, int count)
{
  encoder->previous_count = encoder->current_count;
  encoder->total_count = count;
}
