/*!
  \file
  \brief 直線追従サンプル

  \author Satofumi KAMIMURA

  $Id: followLine.cpp 283 2008-10-19 21:31:36Z satofumi $
*/

#include "DifferentialDrive.h"
#include "delay.h"

using namespace qrk;


int main(int argc, char *argv[])
{
  const char device[] = "/dev/usb/ttyUSB0";

  DifferentialDrive run;
  if (! run.connect(device, 115200)) {
    printf("RunCtrl::connect: %s\n", run.what());
    exit(1);
  }

  run.followLine(Position<int>(0, 0, deg(0)));
  delay(5000);

  run.stop();

  return 0;
}
