/*
  Q_A݂͈͂`
  Satofumi KAMIMURA
  $Id: drawLineArea.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "vmonitor.h"


int main(int argc, char *argv[]) {
  try {
    vmonitor::show();
    vmonitor::setViewMagnify(1.0);

    VXV::Grid p0(0, 0);
    VXV::Grid p1(100, 0);
    enum { Error = 30 };

    std::vector<VXV::Grid3D> points;
    points.push_back(p0);
    points.push_back(p1);

    // _̕`
    vmonitor::drawPoints(points, Red);

    // ~̕`
    vmonitor::drawCircle(p0, Error, Blue);
    vmonitor::drawCircle(p1, Error, Blue);

    // ̕`
    // _W̌vZ
    VXV::Grid c = p0 + p1;
    c.x >>= 1;
    c.y >>= 1;
    vmonitor::printf("center: %d, %d\n", c.x, c.y);

    // Qނ̌XvZ
    VXV::Grid diff = p1 - p0;
    int l = static_cast<int>(sqrt(diff.x * diff.x + diff.y * diff.y));
    vmonitor::printf("length: %d\n", l);

    int base = static_cast<int>(sqrt((l/2) * (l/2) - Error * Error));
    vmonitor::printf("base: %d\n", base);

    double theta = atan2(Error, base);
    vmonitor::printf("theta: %d [deg]\n", static_cast<int>(theta /M_PI*180.0));

    // `
    enum { LineLength = 200 };
    // !!! Q_̊px߂ĕ␳
    VXV::Grid p(c.x + LineLength * cos(theta), c.y + LineLength * sin(theta));
    vmonitor::drawLine(c, p, Red);

    p = VXV::Grid(c.x + LineLength * cos(-theta),
		  c.y + LineLength * sin(-theta));
    vmonitor::drawLine(c, p, Red);

    getchar();
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
