/*
  ticksPosition.cpp ̃eXg
  Satofumi KAMIMURA
  $Id: TicksPositionTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "TicksPositionTest.h"
#include "ticksPosition.h"
#include "typePrint.h"

CPPUNIT_TEST_SUITE_REGISTRATION(TicksPositionTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TicksPositionTest, "TicksPositionTest");

using namespace VXV;


void TicksPositionTest::ticksPositionTest(void) {

  TicksPosition ticksPos;

  // f[^ȂƂ̋mF
  Position expected = Position(0, 0, Direction::deg(0));
  Position actual = ticksPos.getPosition(0);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  // f[^̒ǉ
  ticksPos.add(Position(600, 100, Direction::deg(90)), 1000);
  ticksPos.add(Position(0, -200, Direction::deg(120)), 4000);
  ticksPos.add(Position(0, 0, Direction::deg(0)), 1);

  expected = Position(600, 100, Direction::deg(90));
  actual = ticksPos.getPosition(1000);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  expected = Position(0, -200, Direction::deg(120));
  actual = ticksPos.getPosition(4000);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  // ͈͊O̎w肵ƂɁAł߂lԂ̃eXg
  expected = Position(0, 0, Direction::deg(0));
  actual = ticksPos.getPosition(0);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  expected = Position(0, -200, Direction::deg(120));
  actual = ticksPos.getPosition(8000);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  // ԂꂽlԂ̃eXg
  expected = Position(400, 0, Direction::deg(100));
  actual = ticksPos.getPosition(2000);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  expected = Position(200, -100, Direction::deg(110));
  actual = ticksPos.getPosition(3000);
  actual.zt = Direction::deg(actual.zt.to_deg());
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  // f[^̍폜
  ticksPos.del_olderThan(2);
  expected = Position(600, 100, Direction::deg(90));
  actual = ticksPos.getPosition(0);
  CPPUNIT_ASSERT_EQUAL(expected, actual);
}


void TicksPositionTest::dierctionAverageTest(void) {
  // px̕ςvZ邩eXg
  TicksPosition ticksPos;

  // f[^̒ǉ
  ticksPos.add(Position(0, 0, Direction::deg(170)), 1000);
  ticksPos.add(Position(0, 0, Direction::deg(-150)), 2000);
  ticksPos.add(Position(0, 0, Direction::deg(30)), 3000);
  ticksPos.add(Position(0, 0, Direction::deg(-10)), 4000);

  CPPUNIT_ASSERT_EQUAL(Direction::deg(-170).to_deg(),
		       ticksPos.getPosition(1500).zt.to_deg());
  CPPUNIT_ASSERT_EQUAL(Direction::deg(10).to_deg(),
		       ticksPos.getPosition(3500).zt.to_deg());
}


void TicksPositionTest::rotateTest(void) {
  // [e[geXg
  // !!!

  // !!! A[e[gdg݂ɂȂĂȂI
  // !!! eXgsv
}
