/*
  TCP/IP ڑp̃T[o
  Satofumi KAMIMURA
  $Id: tcpipServer.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "tcpipServer.h"
#include <string.h>
#include "detect_os.h"
#ifdef Linux
#include <sys/utsname.h>
#else
#include <windows.h>
#endif


TcpipServer::TcpipServer(void)
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  : accept_socket(NULL)
#endif
{
}


TcpipServer::~TcpipServer(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (accept_socket) {
    SDLNet_TCP_DelSocket(accept_set, accept_socket);
    SDLNet_FreeSocketSet(accept_set);
    accept_set = NULL;
    SDLNet_TCP_Close(accept_socket);
    accept_socket = NULL;
  }
#endif
}


void TcpipServer::activate(unsigned short port) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  SDLNet_ResolveHost(&ip, NULL, port);

  if (accept_socket) {
    SDLNet_TCP_Close(accept_socket);
  }
  accept_socket = SDLNet_TCP_Open(&ip);
  if (!accept_socket) {
    char* message = new char [80 + strlen(SDLNet_GetError())];
    sprintf(message, "Create TCP/IP server(port %d): %s",
	    port, SDLNet_GetError());
    throw ConnectionDevice_Exception(message);
  }
  accept_set = SDLNet_AllocSocketSet(1);
  SDLNet_TCP_AddSocket(accept_set, accept_socket);
#endif
}


TcpipDevice* TcpipServer::accept(int timeout, bool manualCheckSockets) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  int n = SDLNet_CheckSockets(accept_set, timeout);
  if ((n <= 0) || !SDLNet_SocketReady(accept_socket)) {
    return NULL;
  }
  TCPsocket net_socket = SDLNet_TCP_Accept(accept_socket);
  if (!net_socket) {
    return NULL;
  }
  TcpipDevice* socket = new TcpipDevice(net_socket, manualCheckSockets);
  socket->addSocket(net_socket);

  return socket;
#else
  return NULL;
#endif
}


std::string TcpipServer::getOwnIP(void) {
#if HAVE_CONFIG_H && !HAVE_LIBSDL_NET
  return "";
#else
#ifdef Linux
  struct utsname uts;
  if (uname(&uts) < 0) {
    return "";
  }
  char* host_name = uts.nodename;
#else
  char host_name[MAX_COMPUTERNAME_LENGTH +1];
  DWORD length = sizeof(host_name);
  GetComputerName(host_name, &length);
#endif

  enum { ConnectionTestPort = 24590 };
  IPaddress host_ip;
  if (SDLNet_ResolveHost(&host_ip, host_name, ConnectionTestPort) < 0) {
    return "";
  }
  char ip_name[] = "XXX.XXX.XXX.XXX";
  sprintf(ip_name, "%d.%d.%d.%d",
	  host_ip.host & 0xff, (host_ip.host >> 8) & 0xff,
	  (host_ip.host >> 16) & 0xff, (host_ip.host >> 24) & 0xff);

  return ip_name;
#endif
}
