#ifndef RING_BUFFER_H
#define RING_BUFFER_H

/*!
  \file
  \brief Oobt@
  
  \author Satofumi KAMIMURA
  
  $Id: ringBufferTemplate.h 286 2008-10-20 09:40:22Z satofumi $
*/


/*!
  \brief ŒTCYȃOobt@̃ev[g
*/
template<class C> class RingBuffer {
  typedef unsigned long size_type;
  size_type real_size;
  size_type first;
  size_type last;
  C *buffer;
  RingBuffer(void);

public:
  /*!
    \brief obt@TCYw̃RXgN^

    \param size [i] Oobt@TCY
  */
  RingBuffer(size_type size) : real_size(1), first(0), last(0) {
    while (size > (real_size -1)) {
      real_size <<= 1;
    }
    buffer = new C[real_size];
  }

  ~RingBuffer(void) {
    delete [] buffer;
  }

  /*!
    \brief obt@̃f[^TCY

    \retval obt@̃f[^TCY
  */
  size_type size(void) {
    return (last >= first) ? last - first : real_size - (first - last);
  }

  /*!
    \brief obt@̋󂫃TCY

    \retval obt@̋󂫃TCY
  */
  size_type free_size(void) {
    return real_size -1 - size();
  }

  /*!
    \brief obt@փf[^zu

    \param data [i] f[^
    \param size [i] f[^TCY
  */
  void put(const C* data, size_type size) {
    size_type free_length = free_size();
    size_type len = (size > free_length) ? free_length : size;

    size_type put_end = (len > (real_size - last)) ? real_size : last + len;
    C *p = &buffer[last];
    C *q = (C *)data;
    for (size_type i = last; i < put_end; ++i) {
      *p++ = *q++;
    }

    C *data_last = (C *)data + len;
    if (q < data_last) {
      p = &buffer[0];
      while (q < data_last) {
	*p++ = *q++;
      }
    }
    last = static_cast<size_type>((p - &buffer[0]) & (real_size -1));
  }

  /*!
    \brief obt@TCYύXɃf[^o

    \param data [o] f[^
    \param size [i] f[^TCY

    \retval of[^TCY
  */
  int copy(C* data, size_type size) {
    size_type filled_length = this->size();
    size_type len = (size > filled_length) ? filled_length : size;

    size_type get_end = (len > (real_size - first)) ? real_size : first + len;
    C *p = data;
    C *q = &buffer[first];
    for (size_type i = first; i < get_end; ++i) {
      *p++ = *q++;
    }

    C *data_last = data + len;
    if (p < data_last) {
      q = &buffer[0];
      while (p < data_last) {
	*p++ = *q++;
      }
    }
    return len;
  }

  /*!
    \brief obt@f[^o

    \param data [o] f[^
    \param size [i] f[^TCY

    \retval of[^TCY
  */
  void get(C* data, size_type size) {
    int len = copy(data, size);
    first = (first + len) & (real_size -1);
  }

  /*!
    \brief obt@̃NA
  */
  void clear(void) {
    first = 0;
    last = 0;
  }
};

#endif /* !RING_BUFFER_H */
