/*
  typeUtils.cpp ̃eXg
  Satofumi KAMIMURA
  $Id: TypeUtilsTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "TypeUtilsTest.h"
#include "typeUtils.h"
#include <math.h>

CPPUNIT_TEST_SUITE_REGISTRATION(TypeUtilsTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TypeUtilsTest, "TypeUtilsTest");

using namespace VXV;

void TypeUtilsTest::Grid2DTest(void) {

  // i[ƁAõeXg
  Grid a;
  CPPUNIT_ASSERT_EQUAL(0, a.x);
  CPPUNIT_ASSERT_EQUAL(0, a.y);

  Grid b(2, -3);
  CPPUNIT_ASSERT_EQUAL(2, b.x);
  CPPUNIT_ASSERT_EQUAL(-3, b.y);

  // Zq̃eXg
  a.x = 6;
  a.y = -100;
  Grid c = a + b;
  CPPUNIT_ASSERT_EQUAL(8, c.x);
  CPPUNIT_ASSERT_EQUAL(-103, c.y);

  c = c - Grid(8, -103);
  c += Grid(0, 0);
  CPPUNIT_ASSERT_EQUAL(0, c.x);
  CPPUNIT_ASSERT_EQUAL(0, c.y);

  Grid d = a;
  CPPUNIT_ASSERT(a == d);
  //CPPUNIT_ASSERT(a != c);
}


void TypeUtilsTest::Grid3DTest(void) {

  // i[ƁAõeXg
  Grid3D a;
  CPPUNIT_ASSERT_EQUAL(0, a.x);
  CPPUNIT_ASSERT_EQUAL(0, a.y);
  CPPUNIT_ASSERT_EQUAL(0, a.z);

  Grid3D b(2, -3, 99);
  CPPUNIT_ASSERT_EQUAL(2, b.x);
  CPPUNIT_ASSERT_EQUAL(-3, b.y);
  CPPUNIT_ASSERT_EQUAL(99, b.z);

  // Zq̃eXg
  a.x = 6;
  a.y = -100;
  a.z = 3;
  Grid3D c = a + b;
  CPPUNIT_ASSERT_EQUAL(8, c.x);
  CPPUNIT_ASSERT_EQUAL(-103, c.y);
  CPPUNIT_ASSERT_EQUAL(102, c.z);

  c = a;
  c += b;
  CPPUNIT_ASSERT_EQUAL(8, c.x);
  CPPUNIT_ASSERT_EQUAL(-103, c.y);
  CPPUNIT_ASSERT_EQUAL(102, c.z);

  c = c - Grid3D(8, -103, 102);
  CPPUNIT_ASSERT_EQUAL(0, c.x);
  CPPUNIT_ASSERT_EQUAL(0, c.y);
  CPPUNIT_ASSERT_EQUAL(0, c.z);
}


void TypeUtilsTest::DirectionTest(void) {

  // i[ƁAõeXg
  Direction a = Direction::deg(45);
  CPPUNIT_ASSERT_EQUAL(45, a.to_deg());

  Direction b = Direction::rad(-M_PI / 2.0);
  CPPUNIT_ASSERT_EQUAL(-M_PI/2.0, b.to_rad());

  // ol͈̔͂ɂẴeXg
  Direction c = Direction::deg(180 + 72);
  CPPUNIT_ASSERT_EQUAL(72 - 180, c.to_deg());

  // Zq̃eXg
  Direction d = a + c;
  CPPUNIT_ASSERT_EQUAL(45 + (72 - 180), d.to_deg());

  d = a - c;
  CPPUNIT_ASSERT_EQUAL(45 - (72 - 180), d.to_deg());
}


void TypeUtilsTest::RectTest(void) {

  // i[ƁAõeXg
  Rect a;
  CPPUNIT_ASSERT_EQUAL(0, a.x);
  CPPUNIT_ASSERT_EQUAL(0, a.y);

  Rect b(2, -3, 640, 480);
  CPPUNIT_ASSERT_EQUAL(2, b.x);
  CPPUNIT_ASSERT_EQUAL(-3, b.y);
  CPPUNIT_ASSERT_EQUAL(640, b.w);
  CPPUNIT_ASSERT_EQUAL(480, b.h);
}


void TypeUtilsTest::PositionTest(void) {

  // i[ƁAõeXg
  Position a;
  CPPUNIT_ASSERT_EQUAL(0, a.x);
  CPPUNIT_ASSERT_EQUAL(0, a.y);
  CPPUNIT_ASSERT_EQUAL(0, a.zt.to_deg());

  Position b(2, -3, Direction::deg(120));
  CPPUNIT_ASSERT_EQUAL(2, b.x);
  CPPUNIT_ASSERT_EQUAL(-3, b.y);
  CPPUNIT_ASSERT_EQUAL(120, b.zt.to_deg());
}


void TypeUtilsTest::Position3DTest(void) {
  // Zq̃eXg
  Position3D a;
  CPPUNIT_ASSERT_EQUAL(0, a.x);
  CPPUNIT_ASSERT_EQUAL(0, a.y);
  CPPUNIT_ASSERT_EQUAL(0, a.z);

  Position3D b(2, -3, 99,
	       Direction::deg(0), Direction::deg(0), Direction::deg(0));
  CPPUNIT_ASSERT_EQUAL(2, b.x);
  CPPUNIT_ASSERT_EQUAL(-3, b.y);
  CPPUNIT_ASSERT_EQUAL(99, b.z);

  a.x = 6;
  a.y = -100;
  a.z = 3;
  Position3D c = a + b;
  CPPUNIT_ASSERT_EQUAL(8, c.x);
  CPPUNIT_ASSERT_EQUAL(-103, c.y);
  CPPUNIT_ASSERT_EQUAL(102, c.z);

  c = a;
  c += b;
  CPPUNIT_ASSERT_EQUAL(8, c.x);
  CPPUNIT_ASSERT_EQUAL(-103, c.y);
  CPPUNIT_ASSERT_EQUAL(102, c.z);

  c = a - b;
  CPPUNIT_ASSERT_EQUAL(4, c.x);
  CPPUNIT_ASSERT_EQUAL(-97, c.y);
  CPPUNIT_ASSERT_EQUAL(-96, c.z);

  c = a;
  c -= b;
  CPPUNIT_ASSERT_EQUAL(4, c.x);
  CPPUNIT_ASSERT_EQUAL(-97, c.y);
  CPPUNIT_ASSERT_EQUAL(-96, c.z);
}
