/*
  fileUtils.cpp ̃eXg
  Satofumi KAMIMURA
  $Id: FileUtilsTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "FileUtilsTest.h"
#include "fileUtils.h"

CPPUNIT_TEST_SUITE_REGISTRATION(FileUtilsTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(FileUtilsTest, "FileUtilsTest");


void FileUtilsTest::searchPathTest(void) {

  const char* path[] = { ".", NULL };
  std::string no_file = VXV::searchFile("unknown.txt", path);
  CPPUNIT_ASSERT(no_file.empty());

  std::string fname = VXV::searchFile("Makefile", path);
  CPPUNIT_ASSERT(!fname.empty());
  CPPUNIT_ASSERT_EQUAL(std::string("./Makefile"), fname);
}


void FileUtilsTest::createArgsTest(void) {
  const char* path[] = { "./", NULL };
  std::string fname = VXV::searchFile("b5conf.txt", path);
  CPPUNIT_ASSERT(!fname.empty());

  std::vector<char*> args;
  VXV::createArgs(args, fname.c_str());
  CPPUNIT_ASSERT_EQUAL((size_t)6, args.size());
  CPPUNIT_ASSERT_EQUAL(std::string("--urg_port=/dev/ttyACM0"),
		       std::string(args[0]));
  CPPUNIT_ASSERT_EQUAL(std::string("--run_port=/dev/ttyUSB0"),
		       std::string(args[1]));
  CPPUNIT_ASSERT_EQUAL(std::string("--run_baudrate=115200"),
		       std::string(args[2]));
  CPPUNIT_ASSERT_EQUAL(std::string("--simulator"), std::string(args[3]));
  CPPUNIT_ASSERT_EQUAL(std::string("-s"), std::string(args[4]));
  CPPUNIT_ASSERT_EQUAL(std::string("map.vxm"), std::string(args[5]));
}
